#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//dingle dongleMod01.fsh  by   dubu  
//https://www.shadertoy.com/view/...
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

///////////////////
/* void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = fragCoord.xy / iResolution.xy;
    
    fragColor = texture2D(texture0, uv)*0.5;
}
*/
//////////////////
#define COLOR vec3(0.1, 0.2, 1.)
//#define COLOR (sin(time*vec3(.345, .456, .657))*.4+.6)
#define OFFSET vec2(0.5*cos(0.5*time-sin(time*0.5)), 0.5*sin(0.5*time+cos(time*0.75)))
#define time iTime

float saturate(float x){
    return clamp(x,0.0,1.0);
}

vec3 CenterLight(vec2 p){
    p -= OFFSET;
    p *= 12.;
 	float l = 1. / dot(p, p);
    return l*l * COLOR;
}
vec3 Straws(vec2 p){
    p -= OFFSET;
	float a = atan(p.y, p.x);
    float d = dot(p,p);
    
    float l = saturate(1.-length(p));
    
    l *= 0.5 + 0.5*sin(a*50.+d*5.+sin(time*1.)*20.);
    
    l *= 0.5 + 0.3 * sin(d*10.+a*10.-time*5.);
    return l*l*COLOR;
}
vec3 Lights(vec2 p){
    p -= OFFSET;
    
    float res = 0.0;
    
    for(float i = 0.; i < 500.; ++i){
        float t = time + i*i;
        
        vec2 q = p + vec2(cos(t), sin(t)) * sin(i*11.+time*0.5);
        float l = 0.0003 / pow(length(q), 1.5);
        
        res += l;
    }
    
    res = res*res;
    
    return res * COLOR;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    vec2 uvs = fragCoord.xy/iResolution.xy;
    vec2 uv = (fragCoord*2.-iResolution.xy)/iResolution.y;

    vec3 col = vec3(0.0);
    
    vec2 p = uv;
    
    col += CenterLight(p);
 	col += Straws(p);
    col += Lights(p);
    
    col = max(min(vec3(1.0), col), vec3(0.0));
    vec3 newFrame = pow(col, vec3(1./0.8));
    vec3 oldFrame = texture2D(texture0, uvs).rgb;
    fragColor = vec4(newFrame + oldFrame,1.0)*0.85;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
//gl_FragColor.a = length ( vec3(1.0) - gl_FragColor.rgb );
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

